package com.yd.insurance.base.feign.response;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

@Data
public class ApiInsuranceProductPlanDetailResponse {

    /**
     * 保险产品计划主键id
     */
    private Long id;

    /**
     * 保险产品计划唯一业务ID
     */
    private String planBizId;

    /**
     * 保险产品计划名称
     */
    private String planName;

    /**
     * 状态(0:禁用 1:启用)
     */
    private Integer status;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 产品计划图片
     */
    private String picture;
}
