package com.yd.insurance.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 保险公司网站表
 * </p>
 *
 * @author zxm
 * @since 2025-12-22
 */
@Getter
@Setter
@TableName("insurance_company_website")
public class InsuranceCompanyWebsite implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 保险公司网站表唯一业务ID
     */
    @TableField("insurance_company_website_biz_id")
    private String insuranceCompanyWebsiteBizId;

    /**
     * 保险公司表唯一业务ID
     */
    @TableField("insurance_company_biz_id")
    private String insuranceCompanyBizId;

    /**
     * 网站类型
     */
    @TableField("type")
    private String type;

    /**
     * 网站地址
     */
    @TableField("address")
    private String address;

    /**
     * 更新日
     */
    @TableField("update_date")
    private String updateDate;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
