package com.yd.insurance.base.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceProductPageResponse;
import com.yd.insurance.base.service.dto.InsuranceProductDto;
import com.yd.insurance.base.service.model.InsuranceProduct;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.user.service.dto.SysRoleDto;
import com.yd.user.service.model.SysRole;

import java.util.List;

/**
 * <p>
 * 保险产品基础表 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-08-25
 */
public interface IInsuranceProductService extends IService<InsuranceProduct> {

    IPage<ApiInsuranceProductPageResponse> page(Page<ApiInsuranceProductPageResponse> page,
                                                ApiInsuranceProductPageRequest request,
                                                Boolean isAdmin,
                                                List<String> projectBizIdList,
                                                String loginTenantBizId);

    InsuranceProduct queryOne(String productBizId);

    List<InsuranceProduct> queryList(InsuranceProductDto dto);
}
