package com.yd.insurance.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.insurance.base.feign.request.usersaleexpand.ApiUserSaleExpandPageRequest;
import com.yd.insurance.base.feign.response.usersaleexpand.ApiUserSaleExpandPageResponse;
import com.yd.insurance.base.service.dao.UserSaleExpandMapper;
import com.yd.insurance.base.service.model.UserSaleExpand;
import com.yd.insurance.base.service.service.IUserSaleExpandService;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 系统用户-销售用户扩展表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-19
 */
@Service
public class UserSaleExpandServiceImpl extends ServiceImpl<UserSaleExpandMapper, UserSaleExpand> implements IUserSaleExpandService {

    @Override
    public IPage<ApiUserSaleExpandPageResponse> page(Page<ApiUserSaleExpandPageResponse> page,
                                                     ApiUserSaleExpandPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public UserSaleExpand queryOne(String userSaleBizId) {
        return this.getOne(new LambdaQueryWrapper<UserSaleExpand>().eq(UserSaleExpand::getUserSaleBizId,userSaleBizId));
    }

}
