package com.yd.insurance.base.feign.fallback;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.client.ApiInsuranceAdditionalProductFeignClient;
import com.yd.insurance.base.feign.request.ApiInsuranceAdditionalProductAddRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceAdditionalProductEditRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceAdditionalProductPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceAdditionalProductDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 保险基础数据服务-保险附加产品基础信息Feign降级处理
 */
@Slf4j
@Component
public class ApiInsuranceAdditionalProductFeignFallbackFactory implements FallbackFactory<ApiInsuranceAdditionalProductFeignClient> {

    @Override
    public ApiInsuranceAdditionalProductFeignClient create(Throwable cause) {
        return new ApiInsuranceAdditionalProductFeignClient() {
            @Override
            public Result page(ApiInsuranceAdditionalProductPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiInsuranceAdditionalProductDetailResponse> detail(String additionalProductBizId) {
                return null;
            }

            @Override
            public Result add(ApiInsuranceAdditionalProductAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiInsuranceAdditionalProductEditRequest request) {
                return null;
            }

            @Override
            public Result del(String additionalProductBizId) {
                return null;
            }

            @Override
            public Result editStatus(String additionalProductBizId, Integer status) {
                return null;
            }
        };
    }
}
