package com.yd.insurance.base.feign.client;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.fallback.ApiRelTenantInsuranceProductFeignFallbackFactory;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductListAddRequest;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductListPageRequest;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductSelectPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import javax.validation.constraints.NotNull;

/**
 * 保险基础数据服务-租户保险产品关系信息Feign客户端
 */
@FeignClient(name = "yd-insurance-base-api", fallbackFactory = ApiRelTenantInsuranceProductFeignFallbackFactory.class)
public interface ApiRelTenantInsuranceProductFeignClient {

    /**
     * 租户和保险产品关系分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiRelTenantInsuranceProductListPageRequest request);

    /**
     * 添加租户和保险产品列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/product/list")
    Result addProductList(@Validated @RequestBody ApiRelTenantInsuranceProductListAddRequest request);

    /**
     * 删除租户和保险产品关系
     * @param id 租户和保险产品关系表主键id
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotNull(message = "租户和保险产品关系表主键id不能为空") @RequestParam(value = "id") Long id);

    /**
     * 导入-选择保险产品分页查询（查询当前租户级（当前所属租户绑定的保险产品）或者系统级（全局保险产品在任何地方都适用导入绑定）的保险产品表数据）
     * @param request
     * @return
     */
    @PostMapping("/select/product/page")
    Result selectProductPage(@Validated @RequestBody ApiRelTenantInsuranceProductSelectPageRequest request);
    
}
