package com.yd.insurance.base.feign.fallback.insurancereconciliationcompany;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.client.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyFeignClient;
import com.yd.insurance.base.feign.request.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyAddRequest;
import com.yd.insurance.base.feign.request.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyEditRequest;
import com.yd.insurance.base.feign.request.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyPageRequest;
import com.yd.insurance.base.feign.response.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 保险对账公司信息Feign降级处理
 */
@Slf4j
@Component
public class ApiInsuranceReconciliationCompanyFeignFallbackFactory implements FallbackFactory<ApiInsuranceReconciliationCompanyFeignClient> {
    @Override
    public ApiInsuranceReconciliationCompanyFeignClient create(Throwable cause) {
        return new ApiInsuranceReconciliationCompanyFeignClient() {
            @Override
            public Result page(ApiInsuranceReconciliationCompanyPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiInsuranceReconciliationCompanyDetailResponse> detail(String reconciliationCompanyBizId) {
                return null;
            }

            @Override
            public Result add(ApiInsuranceReconciliationCompanyAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiInsuranceReconciliationCompanyEditRequest request) {
                return null;
            }

            @Override
            public Result del(String reconciliationCompanyBizId) {
                return null;
            }

            @Override
            public Result editStatus(String reconciliationCompanyBizId,String status) {
                return null;
            }
        };
    }
}
