package com.yd.insurance.base.feign.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class ApiRelTenantInsuranceProductListAddRequest{

    /**
     * 租户唯一标识(业务ID)
     */
    @NotBlank(message = "租户唯一标识(业务ID)不能为空")
    private String tenantBizId;

    /**
     * 保险产品唯一标识(业务ID) 列表（选中列表）
     */
    @NotEmpty(message = "保险产品唯一标识(业务ID) 列表（选中列表）不能为空")
    private List<String> productBizIdList;

}
