package com.yd.insurance.base.feign.request.usersignexpand;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;


@Data
public class ApiUserSignExpandAddRequest {

    /**
     * 客户端用户表唯一业务ID
     */
    private String clientUserBizId;

    /**
     * 系统用户唯一标识(业务ID)
     */
    private String userBizId;

    /**
     * 签单用户真实姓名
     */
    @NotBlank(message = "签单用户真实姓名不能为空")
    private String realName;

    /**
     * 执业编码
     */
    @NotBlank(message = "执业编码不能为空")
    private String practiceCode;

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    private String phone;

    /**
     * 证件类型
     */
    @NotBlank(message = "证件类型不能为空")
    private String cardType;

    /**
     * 证件号码
     */
    @NotBlank(message = "证件号码不能为空")
    private String cardNo;

    /**
     * 邮箱
     */
    @NotBlank(message = "邮箱不能为空")
    private String email;

    /**
     * 状态(0:停用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

}
