package com.yd.insurance.base.api.service.impl;

import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiRelInsuranceAdditionalProductDeptService;
import com.yd.insurance.base.feign.dto.CdDeptDto;
import com.yd.insurance.base.feign.dto.SsDeptDto;
import com.yd.insurance.base.service.dto.RelInsuranceAdditionalProductDeptDto;
import com.yd.insurance.base.service.enums.ProductDeptEnum;
import com.yd.insurance.base.service.model.RelInsuranceAdditionalProductDept;
import com.yd.insurance.base.service.service.IRelInsuranceAdditionalProductDeptService;
import com.yd.user.service.dto.SysDeptDto;
import com.yd.user.service.model.SysDept;
import com.yd.user.service.service.ISysDeptService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class ApiRelInsuranceAdditionalProductDeptServiceImpl implements ApiRelInsuranceAdditionalProductDeptService {

    @Autowired
    private IRelInsuranceAdditionalProductDeptService iRelInsuranceAdditionalProductDeptService;

    @Autowired
    private ISysDeptService iSysDeptService;

    /**
     * 更新保险附加产品和部门关系数据（先删后增加）
     * @param type 更新类型(1-所属保险公司 2-出单公司)
     * @param additionalProductBizId 保险附加产品ID（业务id）
     * @param deptBizIdList 部门id列表（业务id）
     * @return
     */
    @Override
    public Result updateRelInsuranceAdditionalProductDeptList(Integer type,
                                                              String additionalProductBizId,
                                                              List<String> deptBizIdList) {
        //先删后增加
        iRelInsuranceAdditionalProductDeptService.removeByAdditionalProductBizIdAndType(type,additionalProductBizId);

        List<RelInsuranceAdditionalProductDept> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(deptBizIdList)) {
            //部门唯一标识(业务ID) 列表（选中列表）不为空
            list = deptBizIdList.stream().map(bizId -> {
                RelInsuranceAdditionalProductDept relInsuranceAdditionalProductDept = new RelInsuranceAdditionalProductDept();
                relInsuranceAdditionalProductDept.setType(type);
                relInsuranceAdditionalProductDept.setAdditionalProductBizId(additionalProductBizId);
                relInsuranceAdditionalProductDept.setDeptBizId(bizId);
                return relInsuranceAdditionalProductDept;
            }).collect(Collectors.toList());

            iRelInsuranceAdditionalProductDeptService.saveOrUpdateBatch(list);
        }
        return Result.success();
    }

    /**
     * 根据附加产品id查询所属公司对象集合
     * @param additionalProductBizId
     * @return
     */
    @Override
    public Result<List<SsDeptDto>> getSsDeptDtoList(String additionalProductBizId) {
        List<SsDeptDto> ssDeptDtoList = new ArrayList<>();

        List<RelInsuranceAdditionalProductDept> list = iRelInsuranceAdditionalProductDeptService.queryList(RelInsuranceAdditionalProductDeptDto.builder()
                .additionalProductBizId(additionalProductBizId)
                .type(ProductDeptEnum.SS.getValue())
                .build());

        if (!CollectionUtils.isEmpty(list)) {
            List<String> deptBizIdList = list.stream().map(RelInsuranceAdditionalProductDept::getDeptBizId).collect(Collectors.toList());
            List<SysDept> sysDeptList = iSysDeptService.queryList(SysDeptDto.builder()
                    .deptBizIdList(deptBizIdList)
                    .build());
            if (!CollectionUtils.isEmpty(sysDeptList)) {
                ssDeptDtoList = sysDeptList.stream().map(dto -> {
                    SsDeptDto ssDeptDto = new SsDeptDto();
                    BeanUtils.copyProperties(dto,ssDeptDto);
                    return ssDeptDto;
                }).collect(Collectors.toList());
            }
        }
        return Result.success(ssDeptDtoList);
    }

    @Override
    public Result<List<CdDeptDto>> getCdDeptDtoList(String additionalProductBizId) {
        List<CdDeptDto> cdDeptDtoList = new ArrayList<>();

        List<RelInsuranceAdditionalProductDept> list = iRelInsuranceAdditionalProductDeptService.queryList(RelInsuranceAdditionalProductDeptDto.builder()
                .additionalProductBizId(additionalProductBizId)
                .type(ProductDeptEnum.CD.getValue())
                .build());

        if (!CollectionUtils.isEmpty(list)) {
            List<String> deptBizIdList = list.stream().map(RelInsuranceAdditionalProductDept::getDeptBizId).collect(Collectors.toList());
            List<SysDept> sysDeptList = iSysDeptService.queryList(SysDeptDto.builder()
                    .deptBizIdList(deptBizIdList)
                    .build());
            if (!CollectionUtils.isEmpty(sysDeptList)) {
                cdDeptDtoList = sysDeptList.stream().map(dto -> {
                    CdDeptDto cdDeptDto = new CdDeptDto();
                    BeanUtils.copyProperties(dto,cdDeptDto);
                    return cdDeptDto;
                }).collect(Collectors.toList());
            }
        }
        return Result.success(cdDeptDtoList);
    }
}
