import request from '@/utils/request'


// 查询项目用户关系列表
export function listProjectUser(data) {
    return request({
        url: '/user/api/relProjectUser/page',
        method: 'post',
        data: data
    })
}
// 查询导入用户关系列表
export function listImportProjectUser(data) {
    return request({
        url: '/user/api/relProjectUser/select/user/page',
        method: 'post',
        data: data
    })
}
// 导入用户列表数据提交
export function addImportProjectUserList(importProjectUserListIds, projectBizId) {
    const data = {
        userBizIdList: importProjectUserListIds,
        projectBizId: projectBizId
    }
    return request({
        url: '/user/api/relProjectUser/add/user/list',
        method: 'post',
        data: data
    })
}
// 删除项目和用户关系
export function delRelProjectUser(id) {
    return request({
        url: '/user/api/relProjectUser/del?id=' + id,
        method: 'delete'
    })
}


// 查询项目角色关系列表
export function listProjectRole(data) {
    return request({
        url: '/user/api/relProjectRole/page',
        method: 'post',
        data: data
    })
}
// 删除项目和角色关系
export function delRelProjectRole(id) {
    return request({
        url: '/user/api/relProjectRole/del?id=' + id,
        method: 'delete'
    })
}
// 查询导入角色关系列表
export function listImportProjectRole(data) {
    return request({
        url: '/user/api/relProjectRole/select/role/page',
        method: 'post',
        data: data
    })
}
// 导入角色列表数据提交
export function addImportProjectRoleList(importProjectRoleListIds, projectBizId) {
    const data = {
        roleBizIdList: importProjectRoleListIds,
        projectBizId: projectBizId
    }
    return request({
        url: '/user/api/relProjectRole/add/role/list',
        method: 'post',
        data: data
    })
}

// 查询项目和菜单关系列表
export function listMenu(data) {
    return request({
        url: '/user/api/relProjectMenu/page',
        method: 'post',
        data: data
    })
}

// 获取项目菜单导入的菜单树
export function getMenuTree(projectBizId) {
    const data = {
        projectBizId: projectBizId
    }
    return request({
        url: '/user/api/relProjectMenu/import/query/menu/tree',
        method: 'post',
        data: data
    })
}
// 获取项目菜单导入选中的菜单列表
export function getImportSelectedMenuList(projectBizId) {
    return request({
        url: '/user/api/relProjectMenu/import/query/selected/menu/list?projectBizId=' + projectBizId,
        method: 'get'
    })
}
// 导入菜单列表数据提交
export function addImportProjectMenuList(data) {
    return request({
        url: '/user/api/relProjectMenu/add/menu/list',
        method: 'post',
        data: data
    })
}


//分配角色-左侧待选列表
export function listLeftRole(data) {
    debugger
    return request({
        url: '/user/api/relUserRole/candidate/project/userRolePage',
        method: 'post',
        data: data
    })
}
//分配角色-右侧已选列表
export function listRightRole(data) {
    return request({
        url: '/user/api/relUserRole/selected/project/userRolePage',
        method: 'post',
        data: data
    })
}
//分配角色-左侧待选列表-添加用户角色列表关系
export function addRightRoleList(data) {
    return request({
        url: '/user/api/relUserRole/add/project/userRoleList',
        method: 'post',
        data: data
    })
}
//分配角色-右侧已选列表-移除用户角色列表关系
export function delRightRoleList(data) {
    return request({
        url: '/user/api/relUserRole/del/project/userRoleList',
        method: 'post',
        data: data
    })
}


//项目和菜单关系树形列表查询
export function getFpMenuTree(data) {
    return request({
        url: '/user/api/relProjectMenu/tree',
        method: 'post',
        data: data
    })
}
//项目和菜单关系树形列表查询
export function getSelectedFpMenuList(data) {
    return request({
        url: '/user/api/relRoleMenu/selected/project/roleMenuList',
        method: 'post',
        data: data
    })
}
//添加菜单角色列表关系
export function addFpMenuList(data) {
    return request({
        url: '/user/api/relRoleMenu/add/project/roleMenuList',
        method: 'post',
        data: data
    })
}
