import request from '@/utils/request'
import { parseStrEmpty } from "@/utils/ruoyi";

// 查询用户列表
export function listUser(data) {
  return request({
    url: '/user/api/sysUser/page',
    method: 'post',
    data: data
  })
}

// 查询用户详细
export function getUser(userBizId) {
  return request({
    url: '/user/api/sysUser/detail?userBizId=' + userBizId,
    method: 'get'
  })
}

// 新增用户
export function addUser(data) {
  return request({
    url: '/user/api/sysUser/add',
    method: 'post',
    data: data
  })
}

// 修改用户
export function updateUser(data) {
  return request({
    url: '/user/api/sysUser/edit',
    method: 'put',
    data: data
  })
}

// 用户状态修改
export function changeUserStatus(data) {
  debugger
  return request({
    url: '/user/api/sysUser/edit/status',
    method: 'patch',
    params: data
  })
}

// 用户密码重置
export function resetUserPwd(userId, password) {
  const data = {
    userId,
    password
  }
  return request({
    url: '/system/user/resetPwd',
    method: 'put',
    data: data
  })
}

// 用户头像上传
export function uploadAvatar(data) {
  return request({
    url: '/system/user/profile/avatar',
    method: 'post',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    data: data
  })
}

