import request from '@/utils/request'

// 查询保险产品列表
export function getInsuranceProductList(data) {
  return request({
    url: '/insurance/base/api/insuranceProduct/page',
    method: 'post',
    data: data
  })
}

// 编辑产品状态
export function editProductStatus(productBizId, status) {
  return request({
    url: `/insurance/base/api/insuranceProduct/edit/status?productBizId=${productBizId}&status=${status}`,
    method: 'patch'
  })
}
// 添加产品
export function addInsuranceProduct(data) {
  return request({
    url: '/insurance/base/api/insuranceProduct/add',
    method: 'post',
    data: data
  })
}
// 修改产品
export function editInsuranceProduct(data) {
  return request({
    url: '/insurance/base/api/insuranceProduct/edit',
    method: 'put',
    data: data
  })
}
// 获取产品详情
export function getProductDetail(productBizId) {
  return request({
    url: `/insurance/base/api/insuranceProduct/detail?productBizId=${productBizId}`,
    method: 'get'
  })
}
// 查询保险计划产品列表
export function getInsuranceProducPlanList(data) {
  return request({
    url: '/insurance/base/api/insuranceProductPlan/page',
    method: 'post',
    data: data
  })
}
// 编辑产品计划状态
export function editPlanStatus(planBizId, status) {
  return request({
    url: `/insurance/base/api/insuranceProductPlan/edit/status?planBizId=${planBizId}&status=${status}`,
    method: 'patch'
  })
}

// 添加保险计划产品列表
export function addInsuranceProducPlan(data) {
  return request({
    url: '/insurance/base/api/insuranceProductPlan/add',
    method: 'post',
    data: data
  })
}
// 添加保险计划产品列表
export function getInsuranceProducPlanDetail(planBizId) {
  return request({
    url: `/insurance/base/api/insuranceProductPlan/detail?planBizId=${planBizId}`,
    method: 'get'
  })
}
// 修改产品计划
export function editInsuranceProducPlan(data) {
  return request({
    url: '/insurance/base/api/insuranceProductPlan/edit',
    method: 'put',
    data: data
  })
}
//查询租户保险产品列表
export function getRelTenantInsuranceList(data) {
  return request({
    url: '/insurance/base/api/relTenantInsuranceProduct/page',
    method: 'post',
    data: data
  })
}
//查询租户保险产品导入列表
export function getImportRelTenantInsuranceList(data) {
  return request({
    url: '/insurance/base/api/relTenantInsuranceProduct/select/product/page',
    method: 'post',
    data: data
  })
}
//租户导入保险产品
export function addImportInsuranceProductList(data) {
  return request({
    url: '/insurance/base/api/relTenantInsuranceProduct/add/product/list',
    method: 'post',
    data: data
  })
}
// 删除租户和保险产品关系
export function delInsuranceProduct(id) {
  return request({
    url: '/insurance/base/api/relTenantInsuranceProduct/del?id=' + id,
    method: 'delete'
  })
}
// 查询保险附加产品列表
export function getAdditionalProductList(data) {
  return request({
    url: '/insurance/base/api/insuranceAdditionalProduct/page',
    method: 'post',
    data: data
  })
}
// 添加保险附加产品
export function addInsuranceAdditionalProduct(data) {
  return request({
    url: '/insurance/base/api/insuranceAdditionalProduct/add',
    method: 'post',
    data: data
  })
}
// 获取附加产品详情
export function getAdditionalProductDetail(additionalProductBizId) {
  return request({
    url: `/insurance/base/api/insuranceAdditionalProduct/detail?additionalProductBizId=${additionalProductBizId}`,
    method: 'get'
  })
}
// 编辑附加产品信息
export function editAdditionalProduct(data) {
  return request({
    url: '/insurance/base/api/insuranceAdditionalProduct/edit',
    method: 'put',
    data: data
  })
}
// 编辑附加产品状态
export function editAdditionalProductStatus(additionalProductBizId, status) {
  return request({
    url: `/insurance/base/api/insuranceAdditionalProduct/edit/status?additionalProductBizId=${additionalProductBizId}&status=${status}`,
    method: 'patch'
  })
}
