import request from '@/utils/request'

// 查询部门列表
export function listDept(query) {
  return request({
    url: '/system/dept/list',
    method: 'get',
    params: query
  })
}

// 查询部门列表（排除节点）
export function listDeptExcludeChild(deptId) {
  return request({
    url: '/system/dept/list/exclude/' + deptId,
    method: 'get'
  })
}

// 查询部门详细
export function getDept(deptBizId) {
  return request({
    url: '/user/api/sysDept/detail?deptBizId=' + deptBizId,
    method: 'get'
  })
}

// 新增部门
export function addDept(data) {
  return request({
    url: '/user/api/sysDept/add',
    method: 'post',
    data: data
  })
}

// 修改部门
export function updateDept(data) {
  return request({
    url: '/system/dept',
    method: 'put',
    data: data
  })
}

// 删除部门
export function delDept(deptId) {
  return request({
    url: '/user/api/sysDept/del?deptBizId=' + deptId,
    method: 'delete'
  })
}

// 编辑部门状态
export function deptStatusChange(deptBizId, status) {
  return request({
    url: `/user/api/sysDept/edit/status?deptBizId=${deptBizId}&status=${status}`,
    method: 'patch'
  })
}
// 编辑部门
export function editDept(data) {
  return request({
    url: '/user/api/sysDept/edit',
    method: 'put',
    data: data
  })
}
//查询部门列表
export function deptList(data) {
  return request({
    url: '/user/api/sysDept/page',
    method: 'post',
    data: data
  })
}
//获取公司列表
export function getAllCompanys(data) {
  return request({
    url: '/user/api/sysDept/company/page',
    method: 'post',
    data: data
  })
}
