import request from '@/utils/request'

// 修改上传图片方法，添加正确的请求配置
export function uploadImage(data) {
  console.log('data', data)
  return request({
    url: '/oss/api/oss/upload',
    data: data,
    method: 'post',
    // 添加以下配置
    headers: {
      'Content-Type': 'multipart/form-data' // 明确指定为multipart类型
    },
    // 如果使用axios，需要设置这个参数
    transformRequest: [
      function (data) {
        return data
      }
    ]
  })
}
// 查询用户是否有访问项目的权限
export function getVisitPermission(projectBizId, tenantBizId) {
  return request({
    url: `/user/api/sysUser/login/permission/project/visit?projectBizId=${projectBizId}&tenantBizId=${tenantBizId}`,
    method: 'get'
  })
}
//获取保险公司列表
export function getAllCompanys(data) {
  return request({
    url: '/user/api/sysDept/company/page',
    method: 'post',
    data: data
  })
}
