package com.yd.oss.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 文件模板表
 * </p>
 *
 * @author zxm
 * @since 2025-09-10
 */
@Getter
@Setter
@TableName("file_template")
public class FileTemplate implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 模板ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 文件元数据表业务ID唯一标识
     */
    @TableField("file_biz_id")
    private String fileBizId;

    /**
     * 文件模板业务ID唯一标识
     */
    @TableField("template_biz_id")
    private String templateBizId;

    /**
     * 模板名称
     */
    @TableField("template_name")
    private String templateName;

    /**
     * 模板描述
     */
    @TableField("template_description")
    private String templateDescription;

    /**
     * 文件类型: 0-PDF, 1-EXCEL, 2-WORD
     */
    @TableField("file_type")
    private Integer fileType;

    /**
     * 模板类型(如:保险行程单,合同等)
     */
    @TableField("template_type")
    private String templateType;

    /**
     * 状态(0:禁用,1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 字段映射配置(JSON格式)
     */
    @TableField("field_mapping")
    private String fieldMapping;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
