package com.yd.oss.api.controller;

import com.yd.common.result.Result;
import com.yd.oss.api.service.ApiOssService;
import com.yd.oss.feign.client.ApiOssFeignClient;
import com.yd.oss.feign.response.ApiFileMetadataResponse;
import com.yd.oss.feign.response.ApiUploadResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/**
 * OSS接口信息
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/oss")
@Validated
public class ApiOssController implements ApiOssFeignClient {

    @Autowired
    private ApiOssService apiOssService;

    /**
     * 上传文件
     * @param file 上传的文件
     * @return
     */
    @Override
    public Result<ApiUploadResponse> uploadFile(MultipartFile file) {
        return apiOssService.uploadFile(file,"","","");
    }

    /**
     * 下载文件
     * @param fileKey 文件唯一标识
     * @return
     */
    @Override
    public Result downloadFile(String fileKey) {
        apiOssService.downloadFile(fileKey,"","",null);
        return Result.success();
    }

    /**
     * 删除文件
     * @param fileKey 文件唯一标识
     * @return
     */
    @Override
    public Result<Boolean> deleteFile(String fileKey) {
        return apiOssService.deleteFile(fileKey,"","","");
    }

    /**
     * 获取文件URL
     * @param fileKey 文件唯一标识
     * @param expirySeconds 文件URL过期秒数
     * @return
     */
    @Override
    public Result<String> getFileUrl(String fileKey, Long expirySeconds) {
        return apiOssService.getFileUrl(fileKey,"","",expirySeconds);
    }

    /**
     * 切换OSS提供商
     * @param providerName OSS提供商名称
     * @return
     */
    @Override
    public Result<Boolean> switchProvider(String providerName) {
        return apiOssService.switchProvider(providerName);
    }

    /**
     * 检查文件是否存在
     * @param fileKey 文件唯一标识
     * @return
     */
    @Override
    public Result<Boolean> doesFileExist(String fileKey) {
        return apiOssService.doesFileExist(fileKey,"","");
    }

    /**
     * 获取文件元数据
     * @param fileKey 文件唯一标识
     * @return
     */
    @Override
    public Result<ApiFileMetadataResponse> getFileMetadata(String fileKey) {
        return apiOssService.getFileMetadata(fileKey,"","");
    }

    @Override
    public Result uploadBatchFile() {
        return apiOssService.uploadBatchFile();
    }
}
