package com.yd.oss.api.service;

import com.yd.common.result.Result;
import com.yd.oss.feign.request.ApiUploadFileRequest;
import com.yd.oss.feign.response.ApiBatchUploadResponse;
import com.yd.oss.feign.response.ApiFileMetadataResponse;
import com.yd.oss.feign.response.ApiUploadResponse;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface ApiOssService {
    Result<ApiUploadResponse> uploadFile(MultipartFile file, String bucket, String provider, String uploadUser);

    Result<ApiUploadResponse> uploadFileBody(MultipartFile file, ApiUploadFileRequest request);

    void downloadFile(String fileKey, String bucket, String provider, HttpServletResponse response);

    Result<Boolean> deleteFile(String fileKey, String bucket, String provider, String operator);

    Result<String> getFileUrl(String fileKey, String bucket, String provider, Long expirySeconds);

    Result<Boolean> switchProvider(String providerName);

    Result<Boolean> doesFileExist(String fileKey, String bucket, String provider);

    Result<ApiFileMetadataResponse> getFileMetadata(String fileKey, String bucket, String provider);

    /**
     * 批量上传文件
     * @param files 文件列表
     * @param request 批量上传请求参数
     * @return 批量上传响应
     */
    Result<ApiBatchUploadResponse> batchUploadFiles(List<MultipartFile> files, ApiUploadFileRequest request);

}
