package com.yd.oss.service.dao;

import com.yd.oss.service.model.OssOperationLog;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 文件操作日志表 Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-08-22
 */
public interface OssOperationLogMapper extends BaseMapper<OssOperationLog> {

    // 根据文件ID查询操作日志
    @Select("SELECT * FROM oss_operation_log WHERE file_id = #{fileId} ORDER BY operation_time DESC")
    List<OssOperationLog> selectByFileId(@Param("fileId") Long fileId);

    // 根据时间范围查询操作日志
    @Select("SELECT * FROM oss_operation_log WHERE operation_time BETWEEN #{start} AND #{end} ORDER BY operation_time DESC")
    List<OssOperationLog> selectByTimeRange(@Param("start") Date start, @Param("end") Date end);

    // 根据操作用户查询操作日志
    @Select("SELECT * FROM oss_operation_log WHERE operation_user = #{operationUser} ORDER BY operation_time DESC")
    List<OssOperationLog> selectByOperationUser(@Param("operationUser") String operationUser);
}
