package com.yd.oss.feign.client;

import com.yd.common.result.Result;
import com.yd.oss.feign.fallback.ApiRelObjectMaterialFeignFallbackFactory;
import com.yd.oss.feign.request.ApiRelObjectMaterialListAddRequest;
import com.yd.oss.feign.request.ApiRelObjectMaterialPageRequest;
import com.yd.oss.feign.request.ApiRelObjectMaterialUploadSubmitRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import javax.validation.constraints.NotBlank;

/**
 * 对象材料关系表信息Feign客户端
 */
@FeignClient(name = "yd-oss-api",path = "/oss/api/relObjectMaterial",fallbackFactory = ApiRelObjectMaterialFeignFallbackFactory.class)
public interface ApiRelObjectMaterialFeignClient {

    /**
     * 分页列表查询-对象材料关系表信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiRelObjectMaterialPageRequest request);

    /**
     * 删除-对象材料关系表信息
     * @param relObjectMaterialBizId
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "对象材料关系表唯一业务ID不能为空") @RequestParam(value = "relObjectMaterialBizId") String relObjectMaterialBizId);

    /**
     * 添加-单个对象和材料列表关系信息
     * @param request
     * @return
     */
    @PostMapping("/add/relObjectMaterialList")
    Result addRelObjectMaterialList(@Validated @RequestBody ApiRelObjectMaterialListAddRequest request);

    /**
     * 上传-提交
     * @param request
     * @return
     */
    @PostMapping("/upload/submit")
    Result submit(@Validated @RequestBody ApiRelObjectMaterialUploadSubmitRequest request);
}
