package com.yd.oss.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 材料基础信息
 * </p>
 *
 * @author zxm
 * @since 2025-12-17
 */
@Getter
@Setter
@TableName("material")
public class Material implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 材料信息表唯一业务ID
     */
    @TableField("material_biz_id")
    private String materialBizId;

    /**
     * 对象类型（字典）
     */
    @TableField("object_type")
    private String objectType;

    /**
     * 资料人（字典）
     */
    @TableField("data_person")
    private String dataPerson;

    /**
     * 资料类型（字典）
     */
    @TableField("data_type")
    private String dataType;

    /**
     * 注意事项
     */
    @TableField("precautions")
    private String precautions;

    /**
     * 状态：0-禁用，1-启用
     */
    @TableField("status")
    private Integer status;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
