package com.yd.oss.feign.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 增强的Excel集合注解，支持复杂数据结构
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ExcelCollection {

    /**
     * 集合元素类型
     */
    Class<?> type();

    /**
     * 起始行（0-based）
     */
    int startRow();

    /**
     * 结束行（0-based，-1表示自动检测）
     */
    int endRow() default -1;

    /**
     * 每个对象占用的行数（默认1行）
     */
    int rowSpan() default 1;

    /**
     * 数据分组模式
     */
    GroupMode groupMode() default GroupMode.SINGLE_ROW;

    /**
     * 分组键字段（用于GROUP_BY_KEY模式）
     */
    String groupKey() default "";

    // 在 ExcelCollection 注解中添加
    String endFlagField() default ""; // 用于判断集合结束的字段名

    /**
     * 下一个对象的第一个字段标题，用于判断集合结束
     */
    String nextFieldTitle() default "";

    /**
     * 数据分组模式枚举
     */
    enum GroupMode {
        /**
         * 单行模式：每行一个对象
         */
        SINGLE_ROW,
        /**
         * 固定行跨度：每个对象占用固定行数
         */
        FIXED_ROW_SPAN,
        /**
         * 按键分组：根据指定字段的值进行分组
         */
        GROUP_BY_KEY
    }
}