package com.yd.oss.feign.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 通用Excel字段注解
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ExcelField {

    /**
     * 字段名称（用于日志和错误提示）
     */
    String name() default "";

    /**
     * 标题行（0-based）
     */
    int titleRow() default -1;

    /**
     * 标题列（0-based）
     */
    int titleCol() default -1;

    /**
     * 值行（0-based，-1表示使用titleRow）
     */
    int valueRow() default -1;

    /**
     * 值列（0-based，-1表示使用titleCol + 1）
     */
    int valueCol() default -1;

    /**
     * 日期格式
     */
    String dateFormat() default "yyyy/MM/dd";

    /**
     * 是否必须
     */
    boolean required() default false;

    /**
     * 默认值
     */
    String defaultValue() default "";

    /**
     * 字段类型
     */
    FieldType fieldType() default FieldType.SINGLE;

    /**
     * 字段类型枚举
     */
    enum FieldType {
        /**
         * 单值字段
         */
        SINGLE,
        /**
         * 列表字段（水平方向）
         */
        HORIZONTAL_LIST,
        /**
         * 列表字段（垂直方向）
         */
        VERTICAL_LIST
    }

    /**
     * 列表字段配置（当fieldType为LIST时使用）
     */
    ListConfig listConfig() default @ListConfig;

    @interface ListConfig {
        /**
         * 起始行（0-based）
         */
        int startRow() default -1;

        /**
         * 起始列（0-based）
         */
        int startCol() default -1;

        /**
         * 结束行（0-based，-1表示自动检测）
         */
        int endRow() default -1;

        /**
         * 结束列（0-based，-1表示自动检测）
         */
        int endCol() default -1;

        /**
         * 方向：true为水平，false为垂直
         */
        boolean horizontal() default true;

        /**
         * 元素类型
         */
        Class<?> elementType() default String.class;
    }
}
