package com.yd.oss.feign.dto;

import lombok.Data;
import java.util.List;

@Data
public class ExportParam {
    /**
     * 要导出的字段名列表
     */
    private List<String> fieldNames;
    
    /**
     * 导出的文件名（不含扩展名）
     */
    private String fileName;
    
    /**
     * 是否上传到OSS
     */
    private Boolean uploadToOss = false;
    
    /**
     * OSS存储路径（如：exports/excel/）
     */
    private String ossPath = "exports/excel/";
}