package com.yd.oss.api.service;

import com.yd.common.result.Result;
import com.yd.oss.feign.dto.ExportParam;
import com.yd.oss.feign.dto.ExportResult;
import com.yd.oss.feign.request.ApiOssExportAppointmentExcelRequest;
import com.yd.oss.feign.response.ApiOssExcelParseResponse;
import com.yd.oss.feign.response.ApiOssExportAppointmentExcelResponse;
import com.yd.oss.feign.result.ImportResult;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface ApiExcelService {

    Result<ApiOssExportAppointmentExcelResponse> exportAppointment(ApiOssExportAppointmentExcelRequest request);

    Result<ApiOssExcelParseResponse> parse(MultipartFile file, String[] sheetClassNames);

    Result<ExportResult> export(List<?> dataList, ExportParam exportParam, Class<?> entityClass);

    Result<ImportResult> importExcel(MultipartFile file, Integer headerRow,
                                     Integer dataStartRow, String requiredFields);

    Result<ImportResult> simpleImport(MultipartFile file);
}
