package com.yd.oss.feign.client;

import com.yd.common.result.Result;
import com.yd.oss.feign.fallback.ApiPdfFeignFallbackFactory;
import com.yd.oss.feign.request.ApiGeneratePdfRequest;
import com.yd.oss.feign.response.ApiGeneratePdfResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * PDF信息Feign客户端
 */
@FeignClient(name = "yd-oss-api",path = "/oss/api/pdf",fallbackFactory = ApiPdfFeignFallbackFactory.class)
public interface ApiPdfFeignClient {

    /**
     * 根据文件模板填充数据生成PDF
     * @param request
     * @return
     */
    @PostMapping("/generate/pdf")
    Result<ApiGeneratePdfResponse> generatePDF(@Validated @RequestBody ApiGeneratePdfRequest request);
}
