package com.yd.oss.api.controller;

import com.yd.common.result.Result;
import com.yd.oss.api.service.ApiPdfService;
import com.yd.oss.feign.client.ApiPdfFeignClient;
import com.yd.oss.feign.request.ApiGeneratePdfRequest;
import com.yd.oss.feign.response.ApiGeneratePdfResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * PDF接口
 *
 * @author zxm
 * @since 2025-08-22
 */
@RestController
@RequestMapping("/pdf")
@Validated
public class ApiPdfController implements ApiPdfFeignClient {

    @Autowired
    private ApiPdfService apiPdfService;

    /**
     * 根据文件模板填充数据生成PDF
     * @param request
     * @return
     */
    @Override
    public Result<ApiGeneratePdfResponse> generatePDF(ApiGeneratePdfRequest request) {
        return apiPdfService.generatePDF(request);
    }
}
