package com.yd.oss.feign.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 批量文件上传响应
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ApiBatchUploadResponse {

    /**
     * 成功上传的文件列表
     */
    private List<ApiUploadResponse> successFiles;

    /**
     * 失败的文件列表
     */
    private List<FailedFile> failedFiles;

    /**
     * 成功数量
     */
    private Integer successCount;

    /**
     * 失败数量
     */
    private Integer failedCount;

    /**
     * 失败的文件信息
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class FailedFile {
        /**
         * 原始文件名
         */
        private String fileName;

        /**
         * 失败原因
         */
        private String reason;
    }
}
