package com.yd.oss.api.service.impl;

import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.oss.api.service.ApiPdfService;
import com.yd.oss.feign.request.ApiGeneratePdfRequest;
import com.yd.oss.feign.response.ApiGeneratePdfResponse;
import com.yd.oss.service.service.PdfService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.io.IOException;

@Slf4j
@Service
public class ApiPdfServiceImpl implements ApiPdfService {

    @Autowired
    private PdfService pdfService;

    /**
     * 根据文件模板填充数据生成PDF
     * @param request
     * @return
     */
    @Override
    public Result<ApiGeneratePdfResponse> generatePDF(ApiGeneratePdfRequest request) {
        ApiGeneratePdfResponse response = new ApiGeneratePdfResponse();
        try {
            String url = pdfService.generatePDF(request.getDataObject(),request.getObjectId(),request.getTemplateType(),request.getCustomFileName());
            response.setUrl(url);
            return Result.success(response);
        } catch (IOException e) {
            e.printStackTrace();
            throw new BusinessException("生成PDF异常");
        }
    }
}
