package com.yd.oss.service.service.impl;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.OSSObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.oss.service.dto.FileProdDto;
import com.yd.oss.service.model.FileTemplate;
import com.yd.oss.service.dao.FileTemplateMapper;
import com.yd.oss.service.model.OssProvider;
import com.yd.oss.service.service.IFileTemplateService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.oss.service.service.IOssProviderService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.io.InputStream;

/**
 * <p>
 * 文件模板表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-10
 */
@Service
@Primary
@Slf4j
public class FileTemplateServiceImpl extends ServiceImpl<FileTemplateMapper, FileTemplate> implements IFileTemplateService {

    @Autowired
    private IOssProviderService ossProviderService;

    @Autowired
    private OSS ossClient; // 注入OSS客户端

    /**
     * 根据模板名称和模板类型获取云服务商和文件信息
     * @param templateName
     * @param templateType
     * @return
     */
    public FileProdDto getFileProd(String templateName,String templateType){
        return baseMapper.getFileProd(templateName,templateType);
    }

    /**
     * 获取模板文件的InputStream
     * @param bucketName
     * @param objectKey
     * @return
     */
    public InputStream getTemplateInputStreamFromOSS(String bucketName, String objectKey) {
        OSSObject object = ossClient.getObject(bucketName, objectKey);
        return object.getObjectContent();
    }

    /**
     * 根据模板业务id和模板类型获取单个对象
     * @param templateBizId
     * @param templateType
     * @return
     */
    @Override
    public FileTemplate queryOne(String templateBizId,String templateType) {
        return this.getOne(new LambdaQueryWrapper<FileTemplate>()
                .eq(StringUtils.isNotBlank(templateBizId),FileTemplate::getTemplateBizId,templateBizId)
                .eq(StringUtils.isNotBlank(templateType),FileTemplate::getTemplateType,templateType));
    }
}
