/*
 * Decompiled with CFR 0.152.
 */
package com.yd.oss.service.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.common.exception.BusinessException;
import com.yd.oss.service.dao.OssProviderMapper;
import com.yd.oss.service.model.OssProvider;
import com.yd.oss.service.service.IOssProviderService;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class OssProviderServiceImpl
extends ServiceImpl<OssProviderMapper, OssProvider>
implements IOssProviderService {
    private static final Logger log = LoggerFactory.getLogger(OssProviderServiceImpl.class);
    @Autowired
    private OssProviderMapper ossProviderMapper;

    @Override
    public OssProvider getDefaultProvider() {
        OssProvider provider = this.ossProviderMapper.selectDefaultProvider();
        if (provider == null) {
            log.error("\u672a\u627e\u5230\u9ed8\u8ba4\u7684OSS\u63d0\u4f9b\u5546");
            throw new BusinessException("\u672a\u627e\u5230\u9ed8\u8ba4\u7684OSS\u63d0\u4f9b\u5546");
        }
        return provider;
    }

    @Override
    public OssProvider getProviderByName(String name) {
        OssProvider provider = this.ossProviderMapper.selectByName(name);
        if (provider == null) {
            log.error("\u672a\u627e\u5230\u540d\u4e3a {} \u7684OSS\u63d0\u4f9b\u5546", (Object)name);
            throw new BusinessException("\u672a\u627e\u5230\u540d\u4e3a " + name + " \u7684OSS\u63d0\u4f9b\u5546");
        }
        return provider;
    }

    @Override
    public OssProvider getProviderById(Long id) {
        OssProvider provider = (OssProvider)this.ossProviderMapper.selectById(id);
        if (provider == null) {
            log.error("\u672a\u627e\u5230ID\u4e3a {} \u7684OSS\u63d0\u4f9b\u5546", (Object)id);
            throw new BusinessException("\u672a\u627e\u5230ID\u4e3a " + id + " \u7684OSS\u63d0\u4f9b\u5546");
        }
        return provider;
    }

    @Override
    public List<OssProvider> getActiveProviders() {
        return this.ossProviderMapper.selectActiveProviders();
    }

    @Override
    public boolean saveProvider(OssProvider provider) {
        LocalDateTime now = LocalDateTime.now();
        if (provider.getId() == null) {
            provider.setCreateTime(now);
            provider.setUpdateTime(now);
            return this.ossProviderMapper.insert(provider) > 0;
        }
        provider.setUpdateTime(now);
        return this.ossProviderMapper.updateById(provider) > 0;
    }

    @Override
    public boolean deleteProvider(Long id) {
        return this.ossProviderMapper.deleteById(id) > 0;
    }
}

