package com.yd.oss.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.oss.api.service.ApiRelObjectMaterialService;
import com.yd.oss.feign.client.ApiRelObjectMaterialFeignClient;
import com.yd.oss.feign.request.ApiRelObjectMaterialListAddRequest;
import com.yd.oss.feign.request.ApiRelObjectMaterialPageRequest;
import com.yd.oss.feign.response.ApiRelObjectMaterialPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 对象材料关系表信息
 *
 * @author zxm
 * @since 2025-12-17
 */
@RestController
@RequestMapping("/relObjectMaterial")
@Validated
public class ApiRelObjectMaterialController implements ApiRelObjectMaterialFeignClient {

    @Autowired
    private ApiRelObjectMaterialService apiRelObjectMaterialService;

    /**
     * 分页列表查询-对象材料关系表信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelObjectMaterialPageResponse>> page(ApiRelObjectMaterialPageRequest request) {
        return apiRelObjectMaterialService.page(request);
    }

    /**
     * 删除-对象材料关系表信息
     * @param relObjectMaterialBizId
     * @return
     */
    @Override
    public Result del(String relObjectMaterialBizId) {
        return apiRelObjectMaterialService.del(relObjectMaterialBizId);
    }

    /**
     * 添加-单个对象和材料列表关系信息
     * @param request
     * @return
     */
    @Override
    public Result addRelObjectMaterialList(ApiRelObjectMaterialListAddRequest request) {
        return apiRelObjectMaterialService.addRelObjectMaterialList(request);
    }

}
