package com.yd.oss.feign.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 通用Excel Sheet注解
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ExcelSheet {

    /**
     * Sheet索引（0-based）
     */
    int sheetIndex() default 0;

    /**
     * Sheet名称
     */
    String sheetName() default "";

    /**
     * 数据起始行（0-based）
     */
    int dataStartRow() default 0;

    /**
     * 是否跳过空行
     */
    boolean skipEmptyRows() default true;

    /**
     * 最大行数限制
     */
    int maxRows() default 1000;
}
