package com.yd.oss.api.controller;

import com.yd.common.result.Result;
import com.yd.oss.api.service.ApiOssFileService;
import com.yd.oss.feign.client.ApiOssFileFeignClient;
import com.yd.oss.feign.request.ApiOssFileListRequest;
import com.yd.oss.feign.response.ApiOssFileListResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 文件元数据信息
 *
 * @author zxm
 * @since 2025-08-22
 */
@RestController
@RequestMapping("/ossFile")
@Validated
public class ApiOssFileController implements ApiOssFileFeignClient {

    @Autowired
    private ApiOssFileService apiOssFileService;

    /**
     * 列表查询-文件元数据信息
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiOssFileListResponse>> list(ApiOssFileListRequest request) {
        return apiOssFileService.list(request);
    }

    /**
     * 删除-文件元数据信息
     * @param fileBizId
     * @return
     */
    @Override
    public Result del(String fileBizId) {
        return apiOssFileService.del(fileBizId);
    }
}
