package com.yd.oss.feign.fallback;

import com.yd.common.result.Result;
import com.yd.oss.feign.client.ApiOssFileFeignClient;
import com.yd.oss.feign.request.ApiOssFileListRequest;
import com.yd.oss.feign.response.ApiOssFileListResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;
import java.util.List;

/**
 * 文件元数据信息Feign降级处理
 */
@Slf4j
@Component
public class ApiOssFileFeignFallbackFactory implements FallbackFactory<ApiOssFileFeignClient> {
    @Override
    public ApiOssFileFeignClient create(Throwable cause) {
        return new ApiOssFileFeignClient() {
            @Override
            public Result<List<ApiOssFileListResponse>> list(ApiOssFileListRequest request) {
                return null;
            }

            @Override
            public Result del(String fileBizId) {
                return null;
            }
        };
    }
}
