/*
 * Decompiled with CFR 0.152.
 */
package com.yd.oss.api.service.impl;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.yd.common.result.Result;
import com.yd.oss.api.service.ApiOssService;
import com.yd.oss.feign.response.ApiFileMetadataResponse;
import com.yd.oss.feign.response.ApiUploadResponse;
import com.yd.oss.service.dto.FileMetadata;
import com.yd.oss.service.dto.UploadResult;
import com.yd.oss.service.service.OssService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ApiOssServiceImpl
implements ApiOssService {
    private static final Logger log = LoggerFactory.getLogger(ApiOssServiceImpl.class);
    @Autowired
    private OssService ossService;

    @Override
    public Result<ApiUploadResponse> uploadFile(MultipartFile file, String bucket, String provider, String uploadUser) {
        ApiUploadResponse response = new ApiUploadResponse();
        try {
            if (StringUtils.isNotBlank((CharSequence)provider)) {
                this.ossService.switchProvider(provider);
            }
            String fileKey = this.ossService.uploadFile(file.getInputStream(), file.getOriginalFilename(), bucket, uploadUser);
            UploadResult result = this.ossService.getUploadResult(fileKey, Duration.ofHours(1L));
            BeanUtils.copyProperties((Object)result, (Object)response);
            return Result.success((Object)response);
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            return Result.fail((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @Override
    public void downloadFile(String fileKey, String bucket, String provider, HttpServletResponse response) {
        try {
            if (StringUtils.isNotBlank((CharSequence)provider)) {
                this.ossService.switchProvider(provider);
            }
            InputStream inputStream = this.ossService.downloadFile(fileKey, bucket);
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileKey + "\"");
            IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25: {}", (Object)fileKey, (Object)e);
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25: " + fileKey, e);
        }
    }

    @Override
    public Result<Boolean> deleteFile(String fileKey, String bucket, String provider, String operator) {
        try {
            if (StringUtils.isNotBlank((CharSequence)provider)) {
                this.ossService.switchProvider(provider);
            }
            boolean result = this.ossService.deleteFile(fileKey, bucket, operator);
            return Result.success((Object)result);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u5220\u9664\u5931\u8d25: {}", (Object)fileKey, (Object)e);
            return Result.fail((String)("\u6587\u4ef6\u5220\u9664\u5931\u8d25: " + e.getMessage()));
        }
    }

    @Override
    public Result<String> getFileUrl(String fileKey, String bucket, String provider, Long expirySeconds) {
        try {
            if (StringUtils.isNotBlank((CharSequence)provider)) {
                this.ossService.switchProvider(provider);
            }
            String url = this.ossService.getFileUrl(fileKey, bucket, Duration.ofSeconds(expirySeconds));
            return Result.success((Object)url);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6URL\u5931\u8d25: {}", (Object)fileKey, (Object)e);
            return Result.fail((String)("\u83b7\u53d6\u6587\u4ef6URL\u5931\u8d25: " + e.getMessage()));
        }
    }

    @Override
    public Result<Boolean> switchProvider(String providerName) {
        try {
            this.ossService.switchProvider(providerName);
            return Result.success((Object)true);
        }
        catch (Exception e) {
            log.error("\u5207\u6362OSS\u63d0\u4f9b\u5546\u5931\u8d25: {}", (Object)providerName, (Object)e);
            return Result.fail((String)("\u5207\u6362OSS\u63d0\u4f9b\u5546\u5931\u8d25: " + e.getMessage()));
        }
    }

    @Override
    public Result<Boolean> doesFileExist(String fileKey, String bucket, String provider) {
        try {
            if (StringUtils.isNotBlank((CharSequence)provider)) {
                this.ossService.switchProvider(provider);
            }
            boolean exists = this.ossService.doesFileExist(fileKey, bucket);
            return Result.success((Object)exists);
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u6587\u4ef6\u5b58\u5728\u5931\u8d25: {}", (Object)fileKey, (Object)e);
            return Result.fail((String)("\u68c0\u67e5\u6587\u4ef6\u5b58\u5728\u5931\u8d25: " + e.getMessage()));
        }
    }

    @Override
    public Result<ApiFileMetadataResponse> getFileMetadata(String fileKey, String bucket, String provider) {
        ApiFileMetadataResponse response = new ApiFileMetadataResponse();
        try {
            if (StringUtils.isNotBlank((CharSequence)provider)) {
                this.ossService.switchProvider(provider);
            }
            FileMetadata metadata = this.ossService.getFileMetadata(fileKey, bucket);
            BeanUtils.copyProperties((Object)metadata, (Object)response);
            return Result.success((Object)response);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5143\u6570\u636e\u5931\u8d25: {}", (Object)fileKey, (Object)e);
            return Result.fail((String)("\u83b7\u53d6\u6587\u4ef6\u5143\u6570\u636e\u5931\u8d25: " + e.getMessage()));
        }
    }
}

