package com.yd.oss.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.oss.service.dto.MaterialDto;
import com.yd.oss.service.model.Material;
import com.yd.oss.service.dao.MaterialMapper;
import com.yd.oss.service.service.IMaterialService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 材料基础信息 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-17
 */
@Service
public class MaterialServiceImpl extends ServiceImpl<MaterialMapper, Material> implements IMaterialService {

    @Override
    public List<Material> queryList(MaterialDto dto) {
        return this.baseMapper.selectList(new LambdaQueryWrapper<Material>()
                .eq(Material::getObjectType,dto.getObjectType()));
    }

}
