package com.yd.oss.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 文件操作日志表
 * </p>
 *
 * @author zxm
 * @since 2025-08-22
 */
@Getter
@Setter
@TableName("oss_operation_log")
public class OssOperationLog implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 文件业务ID唯一标识
     */
    @TableField("file_biz_id")
    private String fileBizId;

    /**
     * 操作类型(upload/delete/download/update)
     */
    @TableField("operation_type")
    private String operationType;

    /**
     * 操作时间
     */
    @TableField("operation_time")
    private LocalDateTime operationTime;

    /**
     * 操作用户
     */
    @TableField("operation_user")
    private String operationUser;

    /**
     * 操作结果(success/failure)
     */
    @TableField("operation_result")
    private String operationResult;

    /**
     * 错误信息
     */
    @TableField("error_message")
    private String errorMessage;

    /**
     * 客户端IP
     */
    @TableField("client_ip")
    private String clientIp;

    /**
     * 耗时(毫秒)
     */
    @TableField("cost_time")
    private Long costTime;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
