package com.yd.oss.feign.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

// Excel字段注解
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface ExcelField {
    String name(); // 标题名称
    int titleRow(); // 标题所在行
    int titleCol(); // 标题所在列
    int valueRow() default -1; // 值所在行（默认与标题同行）
    int valueCol() default -1; // 值所在列（默认标题列+1）
    String dateFormat() default "yyyy/MM/dd"; // 日期格式
}
