package com.yd.product.feign.fallback.expectedcommissionratio;

import com.yd.common.result.Result;
import com.yd.product.feign.client.expectedcommissionratio.ApiExpectedCommissionRatioFeignClient;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioAddRequest;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioBatchSaveRequest;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioEditRequest;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioPageRequest;
import com.yd.product.feign.response.expectedcommissionratio.ApiExpectedCommissionRatioDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 产品服务-预计来佣比率信息Feign降级处理
 */
@Slf4j
@Component
public class ApiExpectedCommissionRatioFeignFallbackFactory implements FallbackFactory<ApiExpectedCommissionRatioFeignClient> {
    @Override
    public ApiExpectedCommissionRatioFeignClient create(Throwable cause) {
        return new ApiExpectedCommissionRatioFeignClient() {
            @Override
            public Result page(ApiExpectedCommissionRatioPageRequest request) {
                return null;
            }

            @Override
            public Result batchSave(ApiExpectedCommissionRatioBatchSaveRequest request) {
                return null;
            }

            @Override
            public Result add(ApiExpectedCommissionRatioAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiExpectedCommissionRatioEditRequest request) {
                return null;
            }

            @Override
            public Result editStatus(String expectedCommissionRatioBizId, Integer status) {
                return null;
            }

            @Override
            public Result<ApiExpectedCommissionRatioDetailResponse> detail(String expectedSpeciesBizId) {
                return null;
            }

            @Override
            public Result del(String expectedSpeciesBizId) {
                return null;
            }

            @Override
            public Result copy(String expectedSpeciesBizId) {
                return null;
            }
        };
    }
}
