package com.yd.product.feign.response.product;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiProductPageResponse {

    /**
     * 产品基础信息表主键ID
     */
    private Long id;

    /**
     * 产品唯一业务ID
     */
    private String productBizId;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品代码
     */
    private String productCode;

    /**
     * 产品状态：0=下架，1=在售 2=预售 3=停售
     */
    private Integer productStatus;

    /**
     * 支持货币
     */
    private String currency;

    /**
     * 销售方式
     */
    private String salesMethod;

    /**
     * 开售时间
     */
    private LocalDateTime saleStartTime;

    /**
     * 停售时间
     */
    private LocalDateTime discontinuationTime;

    /**
     * 产品图片
     */
    private String picture;

    /**
     * 产品所属公司的所在地
     */
    private String location;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
