package com.yd.product.feign.client.announcementcommissionratio;

import com.yd.common.result.Result;
import com.yd.product.feign.fallback.announcementcommissionratio.ApiAnnouncementCommissionRatioFeignFallbackFactory;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioPageRequest;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioSaveRequest;
import com.yd.product.feign.response.announcementcommissionratio.ApiAnnouncementCommissionRatioDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import javax.validation.constraints.NotBlank;

/**
 * 产品服务-公告佣比率信息Feign客户端
 */
@FeignClient(name = "yd-product-api", fallbackFactory = ApiAnnouncementCommissionRatioFeignFallbackFactory.class)
public interface ApiAnnouncementCommissionRatioFeignClient {

    /**
     * 分页列表查询-公告佣比率信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiAnnouncementCommissionRatioPageRequest request);

    /**
     * 保存-公告佣比率信息
     * @param request
     * @return
     */
    @PostMapping("/save")
    Result save(@Validated @RequestBody ApiAnnouncementCommissionRatioSaveRequest request);

    /**
     * 详情-公告佣比率信息
     * @param announcementCommissionRatioBizId 公告佣比率表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiAnnouncementCommissionRatioDetailResponse> detail(@NotBlank(message = "公告佣比率表唯一业务ID不能为空") @RequestParam(value = "announcementCommissionRatioBizId") String announcementCommissionRatioBizId);
    
}
