package com.yd.product.feign.fallback.announcementcommissionratio;

import com.yd.common.result.Result;
import com.yd.product.feign.client.announcementcommissionratio.ApiAnnouncementCommissionRatioFeignClient;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioPageRequest;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioSaveRequest;
import com.yd.product.feign.response.announcementcommissionratio.ApiAnnouncementCommissionRatioDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 产品服务-公告佣比率信息Feign降级处理
 */
@Slf4j
@Component
public class ApiAnnouncementCommissionRatioFeignFallbackFactory implements FallbackFactory<ApiAnnouncementCommissionRatioFeignClient> {
    @Override
    public ApiAnnouncementCommissionRatioFeignClient create(Throwable cause) {
        return new ApiAnnouncementCommissionRatioFeignClient() {
            @Override
            public Result page(ApiAnnouncementCommissionRatioPageRequest request) {
                return null;
            }

            @Override
            public Result save(ApiAnnouncementCommissionRatioSaveRequest request) {
                return null;
            }

            @Override
            public Result<ApiAnnouncementCommissionRatioDetailResponse> detail(String announcementCommissionRatioBizId) {
                return null;
            }
        };
    }
}
