package com.yd.product.feign.request.expectedcommissionratio;

import com.yd.product.feign.dto.ApiExpectedCommissionRatioDto;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class ApiExpectedCommissionRatioSaveRequest {

    /**
     * 产品上架信息表唯一业务ID
     */
    @NotBlank(message = "产品上架信息表唯一业务ID不能为空")
    private String productLaunchBizId;

    /**
     * 预计来佣比率配置列表信息
     */
    @NotEmpty(message = "预计来佣比率配置列表信息不能为空")
    private List<ApiExpectedCommissionRatioDto> apiExpectedCommissionRatioDtoList;
}
