package com.yd.product.feign.response.expectedspecies;

import com.yd.product.feign.dto.ApiSpeciesSettingDto;
import lombok.Data;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApiExpectedSpeciesPageResponse {

    /**
     * 来佣比率规格表主键ID
     */
    private Long id;

    /**
     * 来佣比率规格表唯一业务ID
     */
    private String expectedSpeciesBizId;

    /**
     * 产品上架信息表唯一业务ID
     */
    private String productLaunchBizId;

    /**
     * 产品唯一业务ID
     */
    private String productBizId;

    /**
     * 规格条件列表JSON串
     */
    private String speciesJson;

    /**
     * 上架产品规格配置表信息JSON串对应转化的列表
     */
    private List<ApiSpeciesSettingDto> apiSpeciesSettingDtoList;

    /**
     * 保障计划（0-64岁等）(固定规格条件)
     */
    private String protectionPlan;

    /**
     * 供款年期（5、10、20年期等）(固定规格条件)
     */
    private String paymentTerm;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
