package com.yd.product.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.product.feign.request.announcementspecies.ApiAnnouncementSpeciesPageRequest;
import com.yd.product.feign.response.announcementspecies.ApiAnnouncementSpeciesPageResponse;
import com.yd.product.service.dao.AnnouncementSpeciesMapper;
import com.yd.product.service.model.AnnouncementSpecies;
import com.yd.product.service.service.IAnnouncementSpeciesService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 公告佣比率规格表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-01
 */
@Service
public class AnnouncementSpeciesServiceImpl extends ServiceImpl<AnnouncementSpeciesMapper, AnnouncementSpecies> implements IAnnouncementSpeciesService {

    @Override
    public IPage<ApiAnnouncementSpeciesPageResponse> page(Page<ApiAnnouncementSpeciesPageResponse> page,
                                                          ApiAnnouncementSpeciesPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public AnnouncementSpecies queryOne(String announcementSpeciesBizId) {
        return this.getOne(new LambdaQueryWrapper<AnnouncementSpecies>().eq(AnnouncementSpecies::getAnnouncementSpeciesBizId,announcementSpeciesBizId));
    }

    @Override
    public List<AnnouncementSpecies> queryList(String productLaunchBizId) {
        return null;
    }

    @Override
    public Boolean delByProductLaunchBizId(String productLaunchBizId) {
        return null;
    }

}
