package com.yd.product.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.product.feign.request.product.ApiProductAddRequest;
import com.yd.product.feign.request.product.ApiProductEditRequest;
import com.yd.product.feign.request.product.ApiProductPageRequest;
import com.yd.product.feign.response.product.ApiProductDetailResponse;
import com.yd.product.feign.response.product.ApiProductPageResponse;
import com.yd.product.service.model.Product;

public interface ApiProductService {
    Result<IPage<ApiProductPageResponse>> page(ApiProductPageRequest request);

    Result<String> add(ApiProductAddRequest request);

    Result<String> edit(ApiProductEditRequest request);

    Result<ApiProductDetailResponse> detail(String productBizId);

    Result del(String productBizId);

    Result<Product> checkProductIsExist(String productBizId);
}
