package com.yd.product.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 附加产品-部门关系表（多对多关系）（原有表）
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Getter
@Setter
@TableName("rel_additional_product_dept")
public class RelAdditionalProductDept implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 附加产品ID（业务id）
     */
    @TableField("additional_product_biz_id")
    private String additionalProductBizId;

    /**
     * 部门唯一标识(业务ID)
     */
    @TableField("dept_biz_id")
    private String deptBizId;

    /**
     * 类型(1-所属公司 2-出单公司)
     */
    @TableField("type")
    private Integer type;

    /**
     * 状态(0:禁用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
