package com.yd.product.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.product.api.service.ApiExpectedCommissionRatioService;
import com.yd.product.feign.client.expectedcommissionratio.ApiExpectedCommissionRatioFeignClient;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioPageRequest;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioSaveRequest;
import com.yd.product.feign.response.expectedcommissionratio.ApiExpectedCommissionRatioDetailResponse;
import com.yd.product.feign.response.expectedcommissionratio.ApiExpectedCommissionRatioPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

/**
 * 预计来佣比率信息
 *
 * @author zxm
 * @since 2025-11-20
 */
@RestController
@RequestMapping("/expectedCommissionRatio")
@Validated
public class ApiExpectedCommissionRatioController implements ApiExpectedCommissionRatioFeignClient {

    @Autowired
    private ApiExpectedCommissionRatioService apiExpectedCommissionRatioService;

    /**
     * 分页列表查询-预计来佣比率信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiExpectedCommissionRatioPageResponse>> page(ApiExpectedCommissionRatioPageRequest request) {
        return apiExpectedCommissionRatioService.page(request);
    }

    /**
     * 保存-预计来佣比率信息
     * @param request
     * @return
     */
    @Override
    public Result save(ApiExpectedCommissionRatioSaveRequest request) {
        return apiExpectedCommissionRatioService.save(request);
    }

    /**
     * 详情-预计来佣比率信息
     * @param expectedCommissionRatioBizId 预计来佣比率表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiExpectedCommissionRatioDetailResponse> detail(String expectedCommissionRatioBizId) {
        return apiExpectedCommissionRatioService.detail(expectedCommissionRatioBizId);
    }

}
