package com.yd.product.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.product.service.dto.AttributeSettingDto;
import com.yd.product.service.model.AttributeSetting;
import com.yd.product.service.dao.AttributeSettingMapper;
import com.yd.product.service.service.IAttributeSettingService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 上架产品属性（参数）配置表（新表） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class AttributeSettingServiceImpl extends ServiceImpl<AttributeSettingMapper, AttributeSetting> implements IAttributeSettingService {

    @Override
    public List<AttributeSetting> queryList(AttributeSettingDto dto) {
        List<AttributeSetting> list = baseMapper.selectList(new LambdaQueryWrapper<AttributeSetting>()
                .eq(StringUtils.isNotBlank(dto.getProductLaunchBizId()),AttributeSetting::getProductLaunchBizId,dto.getProductLaunchBizId())
        );
        return list;
    }

    @Override
    public Boolean delByProductLaunchBizId(String productLaunchBizId) {
        return this.remove(new LambdaQueryWrapper<AttributeSetting>().eq(AttributeSetting::getProductLaunchBizId,productLaunchBizId));
    }
}
